package fr.univamu.ticker;

import java.util.ArrayList;
import java.util.List;

public class Ticker {

    private Thread ticking;
    private final List<Tickable> listeners = new ArrayList<>();

    public void add(Tickable listener) {
        listeners.add(listener);
    }

    public void startTicking() {
        ticking = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(1000);
                    listeners.forEach(Tickable::notifyTick);
                }
            } catch (InterruptedException exc) {
                // Done
            }
        });
        ticking.setDaemon(false);
        ticking.start();
    }


    public void stopTicking() {
        ticking.interrupt();
    }
}
