package model;

import util.Neighbour;
import util.Position;
import util.TargetStrategy;

import java.util.List;

public abstract class Extinguisher implements Element{
    protected final TargetStrategy targetStrategy = new TargetStrategy();
    protected Neighbour neighbour;

    protected Position position;
    protected ModelElement element;
    public Extinguisher(Position position){
        this.position = position;
    }

    public Position getPosition() {
        return position;
    }

    public void setPosition(Position position) {
        this.position = position;

    }
    @Override
    public boolean contains(List<Position> positions) {
        return positions.contains(this.getPosition());
    }



    public ModelElement getElement(){
        return this.element;
    }
    public void extinguish(Board board,Position position) {
        if (board.getFires().containsKey(position)) {
            board.getFires().remove(position);
        }

    }

    public abstract List<Position> update(Board<List<ModelElement>> firefighterBoard);

}
