package model;

import util.Neighbour;
import util.Position;

import java.util.*;


public class Fire implements Element {

    private Position position;

    private Neighbour neighbour;
    private final ModelElement modelElement;


    public Fire(Position position){
        this.position = position;
        modelElement = ModelElement.FIRE;
    }


    public Position getPosition() {
        return position;
    }

    @Override
    public ModelElement getElement() {
        return modelElement;
    }

    public void setPosition(Position position) {
        this.position = position;
    }


    public List<Position> update(Board<List<ModelElement>> firefighterBoard) {
        this.neighbour = new Neighbour(firefighterBoard);

        List<Position> modifiedPositions = new ArrayList<>();
        if (firefighterBoard.stepNumber() % 2 == 0) {
            Set<Position> newFirePositions = new HashSet<>();

            for (Position fire : new HashSet<>(firefighterBoard.getFires().keySet())) {
                newFirePositions.addAll(removeMountainAndRoads(firefighterBoard,fire));
            }

            for (Position position : newFirePositions) {
                if (!firefighterBoard.getFires().containsKey(position)) {
                    firefighterBoard.getFires().put(position, new Fire(position));
                    modifiedPositions.add(position);
                }
            }
        }
        return modifiedPositions;
    }
    public boolean contains(List<Position> positions) {
        return positions.contains(this.getPosition());

    }


    public List<Position>removeMountainAndRoads(Board<List<ModelElement>> firefighterBoard,Position position){
        List<Position>neighboursAvailable;

        neighboursAvailable = this.neighbour.getNeighbors().get(position);
        if(firefighterBoard.stepNumber()%4==0){
            List<Position>MountainAndRoadsPositions = new ArrayList<>();
            for(Obstacle obstacle : firefighterBoard.getObstacles().values()){
                if(obstacle instanceof Road || obstacle instanceof Montain){
                    MountainAndRoadsPositions.add(obstacle.getPosition());
                    neighboursAvailable.removeAll(MountainAndRoadsPositions);
                }
            }
        }
        else{

            neighboursAvailable.removeAll(firefighterBoard.getObstacles().keySet());
        }


        return neighboursAvailable;
    }





}