package model;

import util.Neighbour;
import util.Position;


import java.util.ArrayList;


import java.util.List;



public class FireFighter extends Extinguisher {


    public FireFighter(Position position) {
        super(position);
        element = ModelElement.FIREFIGHTER;
    }


    public List<Position> update(Board<List<ModelElement>> firefighterBoard) {
        this.neighbour = new Neighbour(firefighterBoard);
        List<Position> modifiedPositions = new ArrayList<>();

        Position currentPosition = this.getPosition();
        Position newPosition = targetStrategy.neighborClosestToFire(currentPosition, firefighterBoard.getFires().keySet(), this.neighbour.getNeighbors());
        this.setPosition(newPosition);


        modifiedPositions.add(currentPosition);
        modifiedPositions.add(newPosition);

        extinguish(firefighterBoard,newPosition);



        for (Position neighbor : this.neighbour.getNeighbors().get(newPosition)) {
            extinguish(firefighterBoard,neighbor);
            modifiedPositions.add(neighbor);
        }

        for(Obstacle obstacle : firefighterBoard.getObstacles().values()){
            if(obstacle instanceof Montain){
                modifiedPositions.remove(obstacle.getPosition());
            }
        }

        return modifiedPositions;
    }



    }


