package model;

import util.Position;

import java.util.ArrayList;
import java.util.List;

public enum ModelElement {

  FIREFIGHTER(5),
  FIRE(10),
  CLOUD(10),
  ROAD(5),
  MOUNTAIN(5),
  ROCAILLE(3),
  MOTORIZEDFIREFIGHTER(5);
  private final int initialNumber;



  ModelElement(int initialNumber) {
    this.initialNumber = initialNumber;
  }

  public int getInitialNumber(){
    return this.initialNumber;
  }

  public Element getModelElementClass(Position position){

    return switch (this){
      case FIRE -> new Fire(position);
      case ROAD -> new Road(position);
      case FIREFIGHTER -> new FireFighter(position);
      case CLOUD -> new Cloud(position);
      case MOUNTAIN -> new Montain(position);
      case ROCAILLE -> new Rocaille(position);
      case MOTORIZEDFIREFIGHTER -> new MotorizedFireFighter(position);
      default -> throw new IllegalArgumentException("Unknown ModelElement: " + this);
      };

    }




  public static List<Integer> getInitialNumbers(){
    List<Integer>listIninitalNumbers = new ArrayList<>();
    for(ModelElement modelElement : ModelElement.values()){
      listIninitalNumbers.add(modelElement.getInitialNumber());
    }
    return listIninitalNumbers;
  }

  public boolean isObstacle(){
    if(this.getModelElementClass(null) instanceof Obstacle){
      return true;
    }
    return false;
  }

  public boolean isExtinguisher(){
    if(this.getModelElementClass(null) instanceof Extinguisher){
      return true;
    }
    return false;
  }





}

