package model;

import util.Neighbour;
import util.Position;

import java.util.ArrayList;
import java.util.List;

public class MotorizedFireFighter extends Extinguisher {

    public MotorizedFireFighter(Position position) {
        super(position);
        this.element = ModelElement.MOTORIZEDFIREFIGHTER;
    }

    @Override
    public List<Position> update(Board<List<ModelElement>> firefighterBoard) {
        this.neighbour = new Neighbour(firefighterBoard);

        List<Position> modifiedPositions = new ArrayList<>();

        Position currentPosition = this.getPosition();
        Position newPosition = targetStrategy.neighborClosestToFire(currentPosition, firefighterBoard.getFires().keySet(), this.neighbour.getNeighbors());
        Position DoublenewPosition = targetStrategy.neighborClosestToFire(newPosition, firefighterBoard.getFires().keySet(), this.neighbour.getNeighbors());
        this.setPosition(DoublenewPosition);

        modifiedPositions.add(currentPosition);

        modifiedPositions.add(DoublenewPosition);

        extinguish(firefighterBoard, newPosition);
        extinguish(firefighterBoard, DoublenewPosition);


        for (Position neighbor : this.neighbour.getNeighbors().get(DoublenewPosition)) {
            extinguish(firefighterBoard, neighbor);
            modifiedPositions.add(neighbor);
        }

        for (Obstacle obstacle : firefighterBoard.getObstacles().values()) {
            if (obstacle instanceof Montain) {
                modifiedPositions.remove(obstacle.getPosition());
            }
        }

        return modifiedPositions;

    }
}
