package model;

import util.Position;

import java.util.ArrayList;
import java.util.List;

public abstract class Obstacle implements Element{
    protected ModelElement element;
    protected final Position position;
    public Obstacle(Position position){
        this.position = position;
    }
    public boolean contains(List<Position> positions) {
        return positions.contains(this.getPosition());

    }
    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public ModelElement getElement() {
        return this.element;
    }


    public List<Position> update(Board<List<ModelElement>> firefighterBoard) {
        return null;
    }


}
