package model;

import javafx.scene.paint.Color;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayGrid implements Grid{
    private Cell[][] cells;

    public ArrayGrid(int numberOfRows, int numberOfColumns) {
        if (numberOfRows <= 0 || numberOfColumns <= 0)
            throw new IllegalArgumentException("Le nombre de lignes ou de colonnes ne peut pas être nul ou négatif.");
        this.cells = new Cell[numberOfRows][numberOfColumns];
        for (int i = 0; i < numberOfRows; i++) {
            for (int j = 0; j < numberOfColumns; j++) {
                Cell origin = cells[i][j] = new SquareCell();
                tryAddNeighbour2(origin,tryGetCell(i-1,j));
                tryAddNeighbour2(origin,tryGetCell(i,j-1));
            }
        }
       // initNeighbours(numberOfRows,numberOfColumns);
    }
   /*     private void initNeighbours(int numberOfRows, int numberOfColumns) {
            for (int i = 0; i < numberOfRows; i++) {
                for (int j = 0; j < numberOfColumns; j++) {
                    List<Cell> neighbours = getCell(i,j).getNeighbours();
                  //  tryAddNeighbour(i, j - 1, neighbours);
                  //  tryAddNeighbour(i, j + 1, neighbours);
                    tryAddNeighbour(i - 1, j, neighbours);
                    tryAddNeighbour(i + 1, j, neighbours);

                   // getCell(i, j).setNeighbours(neighbours);
                }
            }
        }*/

        private Cell tryGetCell(int row , int column){
             try {
                return this.getCell(row,column);

          } catch (Exception e) {

              }
            return null;
        }
      /*  private void tryAddNeighbour(int row , int column,List<Cell> cells){
            Cell neighbour = tryGetCell(row,column);
            if (neighbour != null){
                cells.add(neighbour);
         }
     } */
      private void tryAddNeighbour2(Cell origin , Cell neighbour){
        if (neighbour != null){
               addNeighbourTo(origin,neighbour);
        }
    }
     private void addNeighbourTo(Cell neighbour1,Cell neighbour2){
        neighbour1.getNeighbours().add(neighbour2);
        neighbour2.getNeighbours().add(neighbour1);
     }


    @Override
    public Cell getCell(int row, int column) {
        return this.cells[row][column];
    }

    @Override
    public int getNumberOfRows() {
        return cells.length;
    }

    @Override
    public int getNumberOfColumns() {
        return cells[0].length;
    }

    @Override
    public void color(ColorGenerator colorGenerator) {
        for(Cell[] column : this.cells ) {
            for(Cell cell : column) {
                cell.setColor(colorGenerator.nextColor(cell));
            }
        }
    }

    public Iterator<Cell> iterator() {
        return new CellGridIterator(this);
    }

}
