package model;

import java.util.Iterator;

public class CellGridIterator implements Iterator<Cell> {
    public ArrayGrid grid;
    public int row;
    public int column;

    CellGridIterator(ArrayGrid grid) {
    this.grid=grid;
    this.row=0;
    this.column=0;
    }

    @Override
    public boolean hasNext() {
        if(this.row==grid.getNumberOfRows()-1 && this.column==grid.getNumberOfColumns()-1) {
            return false;
        }
        return true;
    }

    @Override
    public Cell next() {
        if (hasNext()) {
            if (this.column >= 0 && this.column < grid.getNumberOfColumns()-1) {
                this.column++;
            } else if (this.column == grid.getNumberOfColumns()-1 && this.row < grid.getNumberOfRows()-1) {
                this.column = 0;
                this.row++;
            }

            return grid.getCell(row, column);
        }
        return null;
    }


}
