package model;
import javafx.scene.paint.Color;
import java.util.List;

public class CyclicColorGenerator implements ColorGenerator {
    private ArrayGrid grid;
    private List<Color> colors;
    private int i=0;

    public CyclicColorGenerator(List<Color> colors) {
        this.colors=colors;
    }

    @Override
    public Color nextColor(Cell cell) {
        Color color = colors.get(i);
        if (i<colors.size()-1) {
            i += 1;
        }
        else {
            i=0;
        }
        return color;
    }
}
