package model;

import javafx.scene.paint.Color;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DistinctColorGenerator implements ColorGenerator {
    private List<Color> colors;
    private Color defaultColor;

    public DistinctColorGenerator(Color defaultColor, List<Color> colors) {
        this.colors = colors;
        this.defaultColor = defaultColor;
    }

    @Override
    public Color nextColor(Cell cell) {
        List<Cell> neighbours = cell.getNeighbours();
        List<Color> neighboursColor = new ArrayList<>();
        for (Cell neighbour : neighbours) {neighboursColor.add(neighbour.getColor());}
        int i = 0, j = 0;
        while (colors.get(i) == neighboursColor.get(j)) {
            if (j == neighboursColor.size() - 1 && i == colors.size() - 1) {return defaultColor;}
            if (j == neighboursColor.size() - 1 && i<colors.size()-1) {
                j=0;
                i++;
                }
            else{
                j++;
            }
        }
        return colors.get(i);
    }
}