package model;

import javafx.scene.paint.Color;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class UniformExceptOneGenerator implements ColorGenerator {
    public Color uniformColor;
    public Color exceptionColor;
    public int chosen=0;
    public UniformExceptOneGenerator(Color uniformColor, Color exceptionColor) {
        this.uniformColor=uniformColor;
        this.exceptionColor=exceptionColor;
    }

    @Override
    public Color nextColor(Cell cell) {
        if (chosen == 0) {
            List<Color> colors = Arrays.asList(uniformColor, exceptionColor);
            Random rand = new Random();
            Color randomColor = colors.get(rand.nextInt(colors.size()));
            if (randomColor == exceptionColor) {
                chosen += 1;
            }
            return randomColor;
        } else {
            return uniformColor;
        }
    }
}
