package model;

import javafx.scene.paint.Color;

import java.util.Iterator;

public class ArrayGrid implements Grid{
    private Cell[][] cells;

    public ArrayGrid(int numberOfRows, int numberOfColumns) {
        if(numberOfRows <= 0 || numberOfColumns <= 0)
            throw new IllegalArgumentException("Le nombre de lignes ou de colonnes ne peut pas être nul ou négatif.");
        this.cells = new Cell[numberOfRows][numberOfColumns];
        for(int i = 0; i < numberOfRows; i++) {
            for(int j = 0; j < numberOfColumns; j++) {
                cells[i][j] = new SquareCell();
            }
        }
    }



    @Override
    public Cell getCell(int row, int column) {
        return this.cells[row][column];
    }

    @Override
    public int getNumberOfRows() {
        return cells.length;
    }

    @Override
    public int getNumberOfColumns() {
        return cells[0].length;
    }

    @Override
    public void color(ColorGenerator colorGenerator) {
        for(Cell[] column : this.cells ) {
            for(Cell cell : column) {
                cell.setColor(colorGenerator.nextColor(cell));
            }
        }
    }

    public Iterator<Cell> iterator() {
        return new CellGridIterator(this);
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public Cell next() {
        return null;
    }
}
