package model;

import java.util.Iterator;

public class CellGridIterator implements Iterator<Cell> {
    public ArrayGrid grid;
    public int row;
    public int column;

    public CellGridIterator(ArrayGrid grid) {
    this.grid=grid;
    this.row=0;
    this.column=0;
    }

    @Override
    public boolean hasNext() {
        if(this.row==grid.getNumberOfRows() && this.column==grid.getNumberOfColumns()) {
            return false;
        }
        return true;
    }

    @Override
    public Cell next() {
        if (row>=0 && row< grid.getNumberOfRows()-1){
            this.row=row+1;
        }
        else if(row== grid.getNumberOfRows()-1 && column< grid.getNumberOfColumns()-1){
            this.row=0;
            this.column+=1;
        }
        return grid.getCell(column,row);
    }

}
