package model;

import util.Position;

import java.util.*;
import java.util.Map;

public class Cloud {
    private Position position;
    private final Map<Position, List<Position>> neighbors;
    private final Random randomGenerator = new Random();

    public Cloud(Position startPosition, Map<Position, List<Position>> neighbors) {
        this.position = startPosition;
        this.neighbors = neighbors;
    }

    public void moveAndExtinguishFire(Fire fire) {
        Position newPosition = moveToNewPosition();
        this.position = newPosition;

        extinguishNeighboringFires(fire);
    }

    private Position moveToNewPosition() {
        List<Position> neighborsList = neighbors.get(position);
        return neighborsList.get((int) (Math.random() * neighborsList.size()));
    }

    private void extinguishNeighboringFires(Fire fire) {
        List<Position> neighboringPositions = neighbors.get(position);
        for (Position neighbor : neighboringPositions) {
            if (fire.getFirePositions().contains(neighbor)) {
                fire.extinguishFire(neighbor);
            }
        }
    }

    public Position getPosition() {
        return position;
    }

    public void extinguishFireCloud(Fire fire) {
            fire.getFirePositions().remove(position);
    }
}
