package model;

import util.Position;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Fire {
    private Set<Position> firePositions;
    private Map<Position, List<Position>> neighbors;
  //  private int step =0;

    public Fire(Set<Position> firePositions, Map<Position, List<Position>> neighbors) {
        this.firePositions = firePositions;
        this.neighbors = neighbors;
    }

    public Set<Position> getFirePositions() {
        return firePositions;
    }

    public List<Position> spreadFire() {
        List<Position> modifiedPositions = new ArrayList<>();

        List<Position> newFirePositions = new ArrayList<>();
        for (Position fire : firePositions) {
            newFirePositions.addAll(neighbors.get(fire));
        }
        firePositions.addAll(newFirePositions);
        modifiedPositions.addAll(newFirePositions);
        return newFirePositions;
    }

    public void extinguishFire(Position neighbor) {
        firePositions.remove(neighbor);
    }
}
