package model;

import model.TargetStrategy;
import util.Position;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class Firefighter {
    private Position position;

    public Firefighter(Position position) {
        //this.firefighterPositions = firefighterPositions;
        this.position = position;
        //this.neighbors = neighbors;
    }

    public Position getPosition() {
        return position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Position moveToBestPosition(TargetStrategy targetStrategy, Set<Position> firePositions, Map<Position, List<Position>> neighbors) {
        return targetStrategy.neighborClosestToFire(position, firePositions, neighbors);
    }

    public void extinguish(Position position, Set<Position> firePositions) {
        firePositions.remove(position);
    }
}
