package model;

import util.Position;

import java.util.*;

public class Cloud {
    private Position position;
    private final Map<Position, List<Position>> neighbors;
    private final Random randomGenerator = new Random();

    public Cloud(Position startPosition, Map<Position, List<Position>> neighbors) {
        this.position = startPosition;
        this.neighbors = neighbors;
    }

    public void move() {
        List<Position> validNeighbors = neighbors.get(position);
            this.position = validNeighbors.get(randomGenerator.nextInt(validNeighbors.size()));
    }

    public void extinguishSurroundingFires(Fire fire) {
        for (Position neighbor : neighbors.get(position)) {
            fire.extinguishFire(neighbor); // Éteint les feux adjacents
        }
    }

    public Position getPosition() {
        return position;
    }

    public void protectFromFire(Fire fire) {
        fire.getFirePositions().remove(position);
    }

    public void extinguishSurroundingFires(Set<Position> firePositions, Map<Position, List<Position>> neighbors) {
        for (Position neighbor : neighbors.get(position)) {
            Fire.extinguishFire(neighbor); // Éteint les feux adjacents
        }
    }
}
