package model;

import util.Position;

import java.util.*;

public class Fire {
    private static Set<Position> firePositions;
    private static Map<Position, List<Position>> neighbors;

    public Fire(Set<Position> firePositions, Map<Position, List<Position>> neighbors) {
        this.firePositions = firePositions;
        this.neighbors = neighbors;
    }


    public Position getPosition(){
        return firePositions.iterator().next();
    }

    public void setPosition(Position p){
        this.firePositions.add(p);
    }

    public static Set<Position> getFirePositions() {
        return firePositions;
    }

    public static List<Position> spreadFire(Set<Position> mountains) {
        List<Position> newFires = new ArrayList<>();
        for (Position firePosition : firePositions) {
            for (Position neighbor : neighbors.get(firePosition)) {
                if (!mountains.contains(neighbor) && !firePositions.contains(neighbor)) {
                    newFires.add(neighbor);
                }
            }
        }
        firePositions.addAll(newFires);
        return newFires;
    }

    public static void extinguishFire(Position neighbor) {
        firePositions.remove(neighbor);
    }
}
