package model;

import util.Position;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class Firefighter {
    private Position position;

    public Firefighter(Position position) {
        this.position = position;
    }

    public Position getPosition() {
        return position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Position moveToBestPosition(Set<Position> firePositions, Map<Position, List<Position>> neighbors, Set<Position> mountains) {
        Position currentPosition = getPosition();
        Position bestPosition = currentPosition;
        int minDistance = Integer.MAX_VALUE;

        for (Position neighbor : neighbors.get(currentPosition)) {
            if (mountains.contains(neighbor)) continue;
            for (Position firePosition : firePositions) {
                int distance = Math.abs(firePosition.row() - neighbor.row()) + Math.abs(firePosition.column() - neighbor.column());
                if (distance < minDistance) {
                    minDistance = distance;
                    bestPosition = neighbor;
                }
            }
        }

        return bestPosition;
    }

    public void extinguish(Position position, Set<Position> firePositions) {
        firePositions.remove(position);
    }
}
