package model;

import util.Position;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Mountain {
    private final Position position;

    public Mountain(Position position) {
        this.position = position;
    }
    public Position getPosition(){
        return position;
    }

    public static Set<Position> getMountainPositions(List<Mountain> mountains) {
        return mountains.stream()
                .map(Mountain::getPosition)
                .collect(Collectors.toSet());
    }

}
