package model.update;
import model.Cloud;
import model.Fire;
import util.Position;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloudUpdater {
    private List<Cloud> clouds;

    public CloudUpdater(List<Cloud> clouds) {
        this.clouds = clouds;
    }

    public void updateClouds(Map<Position, List<Position>> neighbors, Set<Position> firePositions) {
        for (Cloud cloud : clouds) {
            cloud.move(); // Déplace le nuage
            cloud.protectFromFire((Fire) firePositions);
            cloud.extinguishSurroundingFires(firePositions, neighbors); // Éteindre les feux autour du nuage
        }
    }
}
