package model.update;

import model.Fire;
import model.Firefighter;
import util.Position;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FirefighterUpdater {
    private final List<Firefighter> firefighters;
    private final Map<Position, List<Position>> neighbors;
    private final Fire fire;

    public FirefighterUpdater(List<Firefighter> firefighters, Map<Position, List<Position>> neighbors, Fire fire) {
        this.firefighters = firefighters;
        this.neighbors = neighbors;
        this.fire = fire;
    }

    public List<Position> updateFirefighters(Set<Position> mountainPositions) {
        List<Position> modifiedPositions = new ArrayList<>();

        for (Firefighter firefighter : firefighters) {
            modifiedPositions.add(firefighter.getPosition());

            Position newPosition = firefighter.moveToBestPosition(fire.getFirePositions(), neighbors, mountainPositions);
            firefighter.setPosition(newPosition);

            modifiedPositions.add(newPosition);

            firefighter.extinguish(newPosition, fire.getFirePositions());

            // Éteindre les feux dans les positions voisines
            List<Position> adjacentFires = neighbors.get(newPosition).stream()
                    .filter(fire.getFirePositions()::contains)
                    .toList();

            for (Position firePosition : adjacentFires) {
                firefighter.extinguish(firePosition, fire.getFirePositions());
                modifiedPositions.add(firePosition);
            }
        }

        return modifiedPositions;
    }
}
