package model.update;

import util.Position;

import java.util.HashMap;
import java.util.*;

public class NeighborManager {
    private final Map<Position, List<Position>> neighbors = new HashMap<>();

    public NeighborManager(int rowCount, int columnCount, Position[][] positions) {
        for (int row = 0; row < rowCount; row++) {
            for (int column = 0; column < columnCount; column++) {
                List<Position> neighborList = new ArrayList<>();
                if (row > 0) neighborList.add(positions[row - 1][column]);
                if (column > 0) neighborList.add(positions[row][column - 1]);
                if (row < rowCount - 1) neighborList.add(positions[row + 1][column]);
                if (column < columnCount - 1) neighborList.add(positions[row][column + 1]);
                neighbors.put(positions[row][column], neighborList);
            }
        }
    }

    public List<Position> getNeighbors(Position position) {
        return neighbors.get(position);
    }
}

