package model.rockpapercisor;

import java.util.List;

import javafx.scene.paint.Color;
import model.Board;
import model.Entity;
import model.Square;
import util.Position;

public class Patient implements Entity{

    private Position position;
    private final Color VIEW_COLOR = Color.BLUE;
    private int age;
    private final int PRIORITY = 1;
    private final boolean isSick;
    public Patient(Position position){
        this.position = position;
        this.age = 0;
        this.isSick = false;
    }
    @Override
    public List<Position> nextTurn(Board<Square> board) {
        if(isSick){
            return List.of();
        }else{
            return List.of(); 
        }
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position p) {
        this.position = p;
    }

    @Override
    public int getAge() {
        return age;
    }

    @Override
    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public void incrementAge() {
        this.age = age + 1;
    }

    @Override
    public Color getViewColor() {
        return this.VIEW_COLOR;
    }

    @Override
    public int getPriority() {
        return this.PRIORITY;
    }
    
}
