package model;

import java.util.ArrayList;
import java.util.List;

import javafx.scene.paint.Color;
import util.Position;

public class EmptySquare implements Entity {

    private Position position;
    private final Color viewColor = Color.WHITE;
    private int age;
    private final int priotity = -1;

    public EmptySquare(Position p) {
        this.position = p;
        this.age = -999;
    }

    public EmptySquare(Position p, int age) {
        this.position = p;
        this.age = age;
    }

    @Override
    public List<Position> nextTurn(Board<Square> board) {
        return new ArrayList<Position>();
    }

    @Override
    public Position getPosition() {
        return position;
    }

    @Override
    public void setPosition(Position p) {
        this.position = p;
    }

    public Color getViewColor() {
        return this.viewColor;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void incrementAge() {
        age = age + 1;
    }

    @Override
    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public int getPriority(){
        return this.priotity;
    }
}
