package model;

import java.util.List;

import javafx.scene.paint.Color;
import util.Position;


public interface Entity {
        /**
     * Exécute un tour de jeu, en vérifiant les cases adjacentes pour des instances de Fire.
     *
     * @param b Le plateau de jeu contenant des entités.
     * @return Une liste de positions affectées durant le tour (que la vue doit mettre à jour).
     */
    public List<Position> nextTurn(Board<Square> board);
    public Position getPosition();
    public void setPosition(Position p);
    public int getAge();
    public void setAge(int age);
    public void incrementAge();
    public Color getViewColor();
    public int getPriority();
}
