package model;

import java.util.ArrayList;
import java.util.List;

import javafx.scene.paint.Color;
import util.Position;

public class Square {
    private List<Entity> entities;
    private Position position;
    public Square(Position position){
        this.entities = new ArrayList<Entity>();
        this.position = position;
    }
    public Square(Position position, Entity entity){
        this.entities = new ArrayList<Entity>();
        this.entities.add(entity);
        this.position = position;
    }

    public List<Entity> getEntities(){
        return this.entities;
    }

    public Position getPosition(){
        return this.position;
    }

    public void addEntity(Entity entity){
        entities.add(entity);
    }

    public void removeEntity(Entity entity){
        entities.remove(entity);
    }

    public void setEntities(List<Entity> entities){
        this.entities = entities;
    }

    public boolean isEmpty(){
        return entities.isEmpty() ||(entities.size() == 1 && entities.get(0) instanceof EmptySquare);
    }

    public int getMinimalAge(){
        int minimalAge = 0;
        for(Entity e : entities){
            if(e.getAge() < minimalAge){
                minimalAge = e.getAge();
            }
        }
        return minimalAge;
    }

    public int getMaxAge(){
        int maxAge = 0;
        for(Entity e : entities){
            if(e.getAge() > maxAge){
                maxAge = e.getAge();
            }
        }
        return maxAge;
    }

    public void incrementAllAges(){
        for(Entity e : entities){
            e.incrementAge();
        }
    }

    public Color getViewColor() {
        if (entities.isEmpty()) {
            return Color.WHITE;
        } else {
            int maxPriority = -1; // Assuming priorities are non-negative
            Color c = Color.WHITE;
            
            // Iterate over entities to find the one with the highest priority
            for (Entity e : entities) {
                // Check for null entities if necessary
                if (e != null && e.getPriority() > maxPriority) {
                    maxPriority = e.getPriority();
                    c = e.getViewColor();
                }
            }
            return c;
        }
    }
    
    
    
}
