package model.firefighterscenario;

import java.util.List;
import java.util.Random;

import javafx.scene.paint.Color;
import model.Board;
import model.EmptySquare;
import model.Entity;
import model.Square;
import util.Position;
import util.PositionUtil;

public class Cloud implements Entity{
    private int age;
    private Position position;
    private final Color viewColor = Color.GRAY;
    private final int priority = 2;

    private static javafx.scene.image.Image cloudImage;
    
    static {
        try {
            cloudImage = new javafx.scene.image.Image(Cloud.class.getResource("/view/nuage.png").toExternalForm());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public Cloud(Position position, Board<Square> b){
        this.age = 0;
        this.position = position;

    }

    public Cloud(Position position, Board<Square> b, int age){
        this.age = age;
        this.position = position;

    }

    @Override
    public List<Position> nextTurn(Board<Square> b) {
        List<Position> adjacentPositions = PositionUtil.generateAdjacentPositions(position, b);
        adjacentPositions.removeIf( p -> b.doesSquareContainEntity(p, Cloud.class));
        adjacentPositions.removeIf( p -> b.doesSquareContainEntity(p, Mountain.class));

        // Filtrer pour obtenir uniquement les positions qui ne contiennent pas de pompier
        adjacentPositions.removeIf(p -> b.doesSquareContainEntity(p, FireFighter.class));

        // Choisir une position aléatoire parmi les mouvements possibles
        if(adjacentPositions.size() < 0){
            return List.of();
        }
        Position next_position = adjacentPositions.get(new Random().nextInt(adjacentPositions.size()));

        // Si la nouvelle position contient un feu, éteindre le feu
        if (b.getStates(next_position).getEntities().stream().anyMatch(element -> element instanceof Fire) ){
            extinguish(next_position, b);
        }
        
        Position old_position = this.position;
        this.position = next_position;
        b.addEntityAtSquare(this, next_position);
        b.clearCaseFrom(this, old_position);

        return List.of(old_position, this.position);
    }


    private Position extinguish(Position p, Board<Square> b) {
        b.getStates(p).getEntities().removeIf(element -> element instanceof Fire);
            List<Entity> entities = b.getStates(p).getEntities();
            for (Entity e : entities) {
                if (e instanceof EmptySquare) {
                    e.setAge(b.stepNumber() + 1);
                }
            }

        return p;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position p) {
        this.position = p;
    }

    @Override
    public int getAge() {
        return age;
    }

    @Override
    public void setAge(int age) {
        this.age =age;
    }

    @Override
    public void incrementAge() {
        this.age += 1;

    }

    @Override
    public Color getViewColor() {
        return this.viewColor;
    }

    @Override
    public int getPriority(){ 
        return this.priority;
    }


    public javafx.scene.image.Image getImage() {
        return cloudImage;
    }



}
