package util;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

import model.Square;
import model.firefighterscenario.Fire;
import model.firefighterscenario.FireFighter;

public class Matrix<E> implements Iterable<E> {
    private ArrayList<ArrayList<E>> matrix;
    private final int rows;
    private final int columns;

    public Matrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.matrix = new ArrayList<>(rows);
        
        // Initialiser chaque ligne de la matrice
        for (int i = 0; i < rows; i++) {
            ArrayList<E> row = new ArrayList<>(columns);
            // Initialiser chaque colonne avec des valeurs nulles
            for (int j = 0; j < columns; j++) {
                row.add(null);
            }
            this.matrix.add(row);
        }
    }

    public E get(int x, int y) {
        validateIndex(x, y);
        return matrix.get(x).get(y);
    }

    public E set(int x, int y, E object) {
        validateIndex(x, y);
        return matrix.get(x).set(y, object);
    }

    public void clear() {
        this.matrix = new ArrayList<>(rows);
        // Initialiser chaque ligne de la matrice
        for (int i = 0; i < rows; i++) {
            ArrayList<E> row = new ArrayList<>(columns);
            // Initialiser chaque colonne avec des valeurs nulles
            for (int j = 0; j < columns; j++) {
                row.add(null);
            }
            this.matrix.add(row);
        }
    }

    public int size() {
        return rows * columns;
    }

    public int getColumns(){
        return this.columns;
    }
    public int getRows(){
        return this.rows;
    }

    
    public void displayMatrix() {
        System.out.print("  ");
        for (int j = 0; j < columns; j++) {
            System.out.print("___ ");
        }
        System.out.println();

        for (int i = 0; i < rows; i++) {
            System.out.print("| ");
            for (int j = 0; j < columns; j++) {
                if (matrix.get(i).get(j) != null) {
                    Square s = (Square) matrix.get(i).get(j);
                    if(s.getEntities().stream().anyMatch(p -> p instanceof Fire)){
                        System.out.print(" F | ");
                    }   
                    else if(s.getEntities().stream().anyMatch(p -> p instanceof FireFighter)){
                        System.out.print(" ff | ");
                    }
                    else if(s.getEntities().stream().anyMatch(p -> p instanceof FireFighter)){
                        System.out.print(" A | ");
                    }else{
                        System.out.print("  | ");
                    }
                    
                } else {
                    System.out.print("   | ");
                }
            }
            System.out.println();
            System.out.print("  ");
            for (int j = 0; j < columns; j++) {
                System.out.print("___ ");
            }
            System.out.println();
        }
    }
    

    private void validateIndex(int x, int y) {
        if (x < 0 || x >= rows || y < 0 || y >= columns) {
            throw new IndexOutOfBoundsException("Indices x: "+ x + " y: " + y + " hors limites pour la matrice.");
        }
    }

    public boolean validateIndex(Position position){
        return position.x() >= 0 && position.x() < rows && position.y() >= 0 && position.y() < columns;
    }
    

    

    @Override
    public Iterator<E> iterator() {
        return new MatrixIterator();
    }

    private class MatrixIterator implements Iterator<E> {
        private int row = 0;
        private int col = 0;

        @Override
        public boolean hasNext() {
            return row < rows && col < columns;
        }

        @Override
        public E next() {
            if (!hasNext()) {
                throw new NoSuchElementException();
            }
            E element = matrix.get(row).get(col);
            col++;
            if (col >= columns) {
                col = 0;
                row++;
            }
            return element;
        }
    }
}
